#include <bits/stdc++.h>
using namespace std;

class RandomizedSet
{
public:
    vector<int> nums;
    unordered_map<int, int> nums_inds;
    /** Initialize your data structure here. */
    RandomizedSet()
    {
    }

    /** Inserts a value to the set. Returns true if the set did not already contain the specified element. */
    bool insert(int val)
    {
        if (nums_inds.count(val) != 0)
            return false;
        nums.push_back(val);
        nums_inds[val] = nums.size() - 1;
        return true;
    }

    /** Removes a value from the set. Returns true if the set contained the specified element. */
    bool remove(int val)
    {
        if (nums_inds.count(val) == 0)
            return false;

        int last = nums.back();
        int ind = nums_inds[val];

        nums[ind] = last;
        nums_inds[last] = ind;

        nums.pop_back();
        nums_inds.erase(val);
        return true;
    }

    /** Get a random element from the set. */
    int getRandom()
    {
        int ind = rand() % nums.size();
        return nums[ind];
    }
};
